-- change directory to program location
parse source  . . pgm
call directory filespec('L', pgm) 

-- define the source file and import it
source=.bsf~new("java.io.File", "17-signed.pdf")
importdoc=BSF.loadClass("org.apache.pdfbox.Loader")
fis =.bsf~new("java.io.FileInputStream","17-signed.pdf")
doc=importdoc~loadPDF(source)

-- extract the signature and the signed content
sig=doc~getSignatureDictionaries~get(0)
sigdata=sig~getContents
signeddata=sig~getSignedContent(fis)

-- convert the signed content to the cms format
pbclass="org.bouncycastle.cms.CMSProcessableByteArray"
cmsdata=.bsf~new(pbclass,signeddata)
cms=.bsf~new("org.bouncycastle.cms.CMSSignedData", cmsdata,sigdata)

-- load the certificate
signerinfo=cms~getSignerInfos~getSigners~iterator~next
cert=cms~getCertificates~getMatches(signerInfo~getSID)~iterator~next

-- create the verifier
vbclass="org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder"
vbuilder=.bsf~new(vbclass)
provider=.bsf~new("org.bouncycastle.jce.provider.BouncyCastleProvider")
vbuilder~setProvider(provider)
verifier=vbuilder~build(cert)

-- verify the signature and save the result
result=signerinfo~verify(verifier)
if result=1 then content=source~getName "has a valid signature"
else content=source~getName "has a invalid signature"

-- create a new document and add a blank page
doc=.bsf~new("org.apache.pdfbox.pdmodel.PDDocument")
page=.bsf~new("org.apache.pdfbox.pdmodel.PDPage")
doc~addPage(page)

-- create a content stream
contclass = "org.apache.pdfbox.pdmodel.PDPageContentStream"
cont=.bsf~new(contclass,doc,page)

-- define font type
fontclass = "org.apache.pdfbox.pdmodel.font.Standard14Fonts"
fname = BSF.loadClass(fontclass)~FontName~HELVETICA_BOLD
font=.bsf~new("org.apache.pdfbox.pdmodel.font.PDType1Font",fname)

-- use the content stream to insert the verify result
cont~beginText
cont~setFont(font, 22)
cont~setLeading(25f)
cont~newLineAtOffset(100, 700)
cont~showText(content)
cont~endText
cont~close

-- save and close the document file
doc~save("18-signature result.pdf")
doc~close

-- get java support
::requires "BSF.CLS"